(function() {
    tinyMCEPopup.requireLangPack();

    var FileManager = {
        settings : {},

        init: function() {

            tinyMCEPopup.restoreSelection();

            var ed = tinyMCEPopup.editor, se = ed.selection, n = se.getNode(), el, self = this, href = '', alt, action = "insert";

            // add insert button action
            $('button#insert').click( function(e) {
                self.insert();
                e.preventDefault();
            });

            tinyMCEPopup.resizeToInnerSize();

            TinyMCE_Utils.fillClassList('date-class');
            TinyMCE_Utils.fillClassList('size-class');

            this.sortables = true;

            el = ed.dom.getParent(n, "A");

            if (el != null && ed.dom.is(el, 'a.jce_file')) {
                action = "update";
            }

            $('#insert').val(tinyMCEPopup.getLang(action, 'Insert', true));

            this.sortlist = {};

            var options = ['icon', 'text', 'size', 'date'];

            if (action == "update") {
                // Get href and convert to relative
                href = ed.convertURL(ed.dom.getAttrib(el, 'href'));

                $('#href').val(href);
                $('#title').val(ed.dom.getAttrib(n, 'title'));
                $('#id').val(ed.dom.getAttrib(n, 'id'));
                $('#style').val(ed.dom.getAttrib(n, "style"));
                $('#charset').val(ed.dom.getAttrib(n, 'charset'));
                $('#hreflang').val(ed.dom.getAttrib(n, 'hreflang'));
                $('#dir').val(ed.dom.getAttrib(n, 'dir'));
                $('#lang').val(ed.dom.getAttrib(n, 'lang'));
                $('#tabindex').val(ed.dom.getAttrib(n, 'tabindex', typeof(n.tabindex) != "undefined" ? n.tabindex : ""));
                $('#accesskey').val(ed.dom.getAttrib(n, 'accesskey', typeof(n.accesskey) != "undefined" ? n.accesskey : ""));
                $('#type').val(ed.dom.getAttrib(n, 'type'));
                $('#target').val(ed.dom.getAttrib(n, 'target'));
                $('#classes').val(ed.dom.getAttrib(n, 'class'));

                // Select by the values
                $('#targetlist').val(ed.dom.getAttrib(n, 'target'));
                $('#dir').val(ed.dom.getAttrib(n, 'dir'));
                $('#rev').val(ed.dom.getAttrib(n, 'rel'), true);

                $('#rel').val( function() {
                    var v = ed.dom.getAttrib(n, 'rel');

                    if ($('option[value="'+ v +'"]', this).length == 0) {
                        $(this).append(new Option(v, v));
                        $(this).val(v);
                    }
                });

                $('#classlist').val(ed.dom.getAttrib(n, 'class'));
                $('#targetlist').val(ed.dom.getAttrib(n, 'target'));

                $.each(el.childNodes, function(i, n) {
                    if (n.nodeName == 'IMG') {
                        self.sortlist['icon'] = n.src;
                    }
                    if (n.nodeName == '#text' && /[\w]+/i.test(n.data)) {
                    	var text = tinymce.trim(n.data);
                    	self.sortlist['text'] = text;
                        $('#text').val(text);
                    }
                    if (/jce_(fm_size|size)/i.test(n.className)) {
                        self.sortlist['size'] = tinymce.trim(n.innerHTML);

                        $('#size-class').val(tinymce.trim(n.className.replace(/jce_(fm_size|size)/i, '')));
                    }
                    if (/jce_(fm_date|date)/i.test(n.className)) {
                        self.sortlist['date'] = tinymce.trim(n.innerHTML);
                        $('#date-class', tinymce.trim(n.className.replace(/jce_(fm_date|date)/i, '')));
                    }
                });
                
                // add default options
                $.each(options, function(i, v) {
                	if (!self.sortlist[v]) {
                		self.sortlist[v] = '';
                	}
                });

                if (ed.dom.hasClass(el, 'jce_file_custom')) {
                    this.sortables = false;
                }
            } else {
                $.extend(this.sortlist, {
                    icon: '',
                    text: '',
                    size: '',
                    date: ''
                });

                var content = se.getContent();

                if (/[<>]+/g.test(content)) {
                    this.sortables = false;
                } else {
                    $('#text').val(content);
                }
            }

            // Initialise Plugin
            $.Plugin.init();

            // Setup Media Manager
            WFFileBrowser.init('#href', {
                onFileClick : function(e, file) {
                    self.selectFile(file);
                },

                onFileInsert : function(e, file) {
                    self.selectFile(file);
                }

            });

            // setup sortable options
            this.setSortables();
        },

        insert: function() {
            var ed = tinyMCEPopup.editor;

            AutoValidator.validate(document);

            if ($('#href').val() === '') {
                $.Dialog.alert(tinyMCEPopup.getLang('filemanager_dlg.no_src', 'Please select a file or enter a file URL'));

                return false;
            }
            if ($('#text').val() === '') {
                $.Dialog.alert(tinyMCEPopup.getLang('filemanager_dlg.no_text', 'Text for the file link is required'));

                return false;
            }

            this.insertAndClose();
        },

        insertAndClose: function() {
            tinyMCEPopup.restoreSelection();

            var ed = tinyMCEPopup.editor, se = ed.selection, n = se.getNode(), v, el, content, spans = {}, args = {}, html = '';

            // Fixes crash in Safari
            if (tinymce.isWebKit)
                ed.getWin().focus();

            content = se.getContent();

            var ext 		= $.String.getExt($('#href').val());

            var dateclass 	= $('#date-class').val();
            var sizeclass 	= $('#size-class').val();

            var options 	= $('#sortGroup').sortable('toArray');
            var format		= this.settings.icon_format;

            var icon 		= format.replace('{$name}', this.settings.icon_map[ext] , 'i');
            icon 			= $.String.path(this.settings.icon_path, icon);

            if (icon.charAt(0) == '/') {
                icon = icon.substring(1);
            }

            $.extend(spans, {
                icon: '<img class="jce_icon" src="' + icon + '" style="border:0px;vertical-align:middle;" alt="'+ ext +'" />',
                date: '<span class="' + dateclass + 'jce_date" style="margin-left:5px;">' + $('input:text', '#option-date').val() + '</span>',
                size: '<span class="' + sizeclass + 'jce_size" style="margin-left:5px;">' + $('input:text', '#option-size').val() + '</span>',
                text: $('#text').val()
            });

            var attribs = ['href', 'title', 'target', 'id', 'style', 'class', 'rel', 'rev', 'charset', 'hreflang', 'dir', 'lang', 'tabindex', 'accesskey', 'type'];

            tinymce.each(attribs, function(k) {
                var v = $('#' + k).val();

                if (k == 'href') {
                    v = $.String.encodeURI(v, true);
                }

                if (k == 'class') {
                    v = $('#classlist').val() || $('#classes').val() || '';
                }

                args[k] = v;
            });

            var h = [];

            $.each(options, function(k, v) {
                if ($('#' + v + ' input.checkbox').is(':checked')) {
                    h.push(spans[v.replace('option-', '')]);
                }
            });
            
            // no selection
            if (se.isCollapsed()) {
                ed.execCommand('mceInsertContent', false, '<a href="javascript:mctmp(0);"></a>', {
                    skip_undo : 1
                });

                tinymce.each(ed.dom.select('a[href=javascript:mctmp(0);]'), function(link) {
                    ed.dom.setAttribs(link, args);

                    el = link;
                });

                // create link on selection or update existing link
            } else {
                if (el = ed.dom.getParent(se.getNode(), "A")) {
                    if (args.href) {
                        ed.dom.setAttribs(el, args);
                    } else {
                        ed.dom.remove(el, true);
                    }

                } else {
                    ed.execCommand('CreateLink', false, 'javascript:mctmp(0);');

                    tinymce.each(ed.dom.select('a[href=javascript:mctmp(0);]'), function(link) {
                        ed.dom.setAttribs(link, args);

                        el = link;
                    });

                }
            }

            el.innerHTML = h.join('');
            // add identifier class
            ed.dom.addClass(el, 'jce_file');

            tinyMCEPopup.close();
        },

        setSortables: function() {
            var enabled 	= this.sortables;
            var sortlist 	= this.sortlist || {};

            $.each(sortlist, function(k, v) {
                var type = (k == 'size' || k == 'date') ? 'text' : 'hidden';

                $('#sortGroup').append(
                '<li class="sortItem" id="option-'+ k +'"><label class="label">' + tinyMCEPopup.getLang('filemanager_dlg.' + k, k) + '</label>' +
                '<input type="'+ type +'" value="'+ v +'" />' +
                '<input type="checkbox" class="checkbox" />' +
                '</li>'
                );

                // add event
                $('li.sortItem', $('#sortGroup')).click( function(e) {
                    var el = e.target;

                    if (el.disabled)
                        return;

                    if (el.checked && $(el).siblings('input:hidden, input:text').val() == '') {
                        // get MediaManager selection
                        var items 	= WFFileBrowser.get('getSelectedItems');

                        if ($(el).parent('li').is('#option-size, #option-date') && items.length) {
                            $('#insert').attr('disabled', true);

                            $(el).parent('li').addClass('loading');

                            $.JSON.request('getFileDetails', $(items[0]).attr('id'), function(o) {

                                if (!o.error) {
                                    $(el).siblings('input:hidden, input:text').val(o[k]);
                                }

                                $('#insert').attr('disabled', false);

                                $(el).parent('li').removeClass('loading');
                            });

                        }
                    }
                });

                $('#option-' + k + ' input:checkbox').attr('checked', (v !== '' || k == 'text'));
            });

            $.each(['size', 'date'], function(i, n) {
                
                $('<input type="button" title="' + tinyMCEPopup.getLang('filemanager_dlg.reload_value', 'Reload Value') + '" />').click( function() {
                    var items 	= WFFileBrowser.get('getSelectedItems');
                    if (items.length) {
                        $('#insert').attr('disabled', true);

                        $('#option-' + n).addClass('loading');

                        $.JSON.request('getFileDetails', $(items[0]).attr('id'), function(o) {
                            if (!o.error) {
                                $('input:hidden, input:text', '#option-' + n).val(o[n]);
                            }

                            $('#insert').attr('disabled', false);

                            $('#option-' + n).removeClass('loading');
                        });

                    }
                }).insertBefore($('#option-' + n + ' input:checkbox'));

            });

            $('#option-text input:checkbox').attr('disabled', true);

            if (enabled) {
                $('#options-enabled').show();
                $('#options-disabled').hide();
            } else {
                $('#options-enabled').hide();
                $('#options-disabled').show();
            }

            $('#sortGroup').sortable({
                axis : 'x'
            });
        },

        /**
         * Select a file
         * @param file File element
         */
        selectFile : function(file) {
            var self 	= this;
            var dir		= WFFileBrowser.getCurrentDir();
            var name 	= $(file).attr('title');
            var src		= $.String.path(WFFileBrowser.getBaseDir(), $(file).attr('id'));

            src	= src.charAt(0) == '/' ? src.substring(1) : src;

            $('#href').val(src);

            // size
            $('input:text', '#option-size').val($.String.formatSize($(file).data('size')));
            // date
            $('input:text', '#option-date').val($.String.formatDate($(file).data('modified'), this.settings.date_format));

            if ($('#text').val() !== '' && this.settings.text_alert == 1) {
                $.Dialog.confrim(tinyMCEPopup.getLang('filemanager_dlg.replace_text', 'Replace file link text with file name?'), function(state) {
                    if (state) {
                        $('#text').val(name);
                    }
                });

            } else {
                $('#text').val(name);
            }
        }

    };
    window.FileManager = FileManager;

    tinyMCEPopup.onInit.add(FileManager.init, FileManager);
})();